package examples.entity.uni.many_to_one;

import java.io.Serializable;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class Employee implements Serializable {
	private int id;
	private String name;
	private BusinessAddress address;

	public Employee() {
		id = (int)System.nanoTime();
	}
	
	@Id
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	@ManyToOne(cascade={CascadeType.ALL})
	public BusinessAddress getAddress() {
		return address;
	}

	public void setAddress(BusinessAddress address) {
		this.address = address;
	}
}
